/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.dlsfls;

import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.searchguard.queries.QueryBuilderTraverser;
import com.floragunn.searchsupport.queries.Query;
import java.util.function.Function;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.join.ToChildBlockJoinQuery;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.query.TermsQueryBuilder;

public class DlsRestriction {
    public static final DlsRestriction NONE = new DlsRestriction((ImmutableList<Query>)ImmutableList.empty());
    public static final DlsRestriction FULL = new DlsRestriction((ImmutableList<Query>)ImmutableList.of((Object)Query.MATCH_NONE));
    private static final org.apache.lucene.search.Query NON_NESTED_QUERY = new BooleanQuery.Builder().add((org.apache.lucene.search.Query)new MatchAllDocsQuery(), BooleanClause.Occur.FILTER).add((org.apache.lucene.search.Query)new PrefixQuery(new Term("_type", "__")), BooleanClause.Occur.MUST_NOT).build();
    private final ImmutableList<Query> queries;

    DlsRestriction(ImmutableList<Query> queries) {
        this.queries = queries;
    }

    public boolean isUnrestricted() {
        return this.queries.isEmpty();
    }

    public BooleanQuery.Builder toQueryBuilder(SearchExecutionContext searchExecutionContext, Function<org.apache.lucene.search.Query, org.apache.lucene.search.Query> queryMapFunction) {
        if (this.queries.isEmpty()) {
            return null;
        }
        boolean hasNestedMapping = searchExecutionContext.hasNested();
        BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
        queryBuilder.setMinimumNumberShouldMatch(1);
        for (Query dlsQuery : this.queries) {
            org.apache.lucene.search.Query luceneQuery = searchExecutionContext.toQuery(dlsQuery.getQueryBuilder()).query();
            if (queryMapFunction != null) {
                luceneQuery = queryMapFunction.apply(luceneQuery);
            }
            queryBuilder.add(luceneQuery, BooleanClause.Occur.SHOULD);
            if (!hasNestedMapping) continue;
            DlsRestriction.handleNested(searchExecutionContext, queryBuilder, luceneQuery);
        }
        return queryBuilder;
    }

    boolean containsTermLookupQuery() {
        for (Query query : this.queries) {
            if (!QueryBuilderTraverser.exists((QueryBuilder)query.getQueryBuilder(), q -> q instanceof TermsQueryBuilder && ((TermsQueryBuilder)q).termsLookup() != null)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.isUnrestricted()) {
            return "DLS:<none>";
        }
        return "DLS:" + this.queries;
    }

    private static void handleNested(SearchExecutionContext searchExecutionContext, BooleanQuery.Builder dlsQueryBuilder, org.apache.lucene.search.Query parentQuery) {
        BitSetProducer parentDocumentsFilter = searchExecutionContext.bitsetFilter(NON_NESTED_QUERY);
        dlsQueryBuilder.add((org.apache.lucene.search.Query)new ToChildBlockJoinQuery(parentQuery, parentDocumentsFilter), BooleanClause.Occur.SHOULD);
    }

    public ImmutableList<Query> getQueries() {
        return this.queries;
    }

    public static class IndexMap {
        public static final IndexMap NONE = new IndexMap(null);
        private final ImmutableMap<String, DlsRestriction> indexMap;

        IndexMap(ImmutableMap<String, DlsRestriction> indexMap) {
            this.indexMap = indexMap;
        }

        public boolean isUnrestricted() {
            return this.indexMap == null;
        }

        public ImmutableMap<String, DlsRestriction> getIndexMap() {
            return this.indexMap;
        }

        boolean containsTermLookupQuery() {
            if (this.indexMap == null) {
                return false;
            }
            for (DlsRestriction restriction : this.indexMap.values()) {
                if (!restriction.containsTermLookupQuery()) continue;
                return true;
            }
            return false;
        }
    }
}

